#version 330
#extension GL_EXT_gpu_shader4 : enable
//undulaMod01.fsh  by   HaleyHalcyon
//https://www.shadertoy.com/view/wltyzN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec3 roll(uvec2 xy, uint t) {
    const uint a = 1664525u;
    const uint m = 1013904223u;

    uint seed = 1818420u * xy.x + 78265178u * xy.y + 237698117u * t;
    
    uint x0 = (seed * a) % m;
    uint x = (x0 * a) % m;
    
    vec3 xvec = vec3(x & 3u, (x >> 4u) & 3u, (x >> 8u) & 3u);
    return xvec / 3.;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float Time = fract(iTime / 4.);
    uint time = uint(floor(iTime * 5.));
   
    // Normalized pixel coordinates (from 0 to 1)
    float scale = min(iResolution.x, iResolution.y);
    vec2 uv = gl_FragCoord.xy / scale;
    uv -= vec2(iResolution.x / scale, iResolution.y / scale) / 2.;
    uv *= 2.0;
    
    float linDis = distance(uv, vec2(0));
    float lolDis = 7. * log(linDis) - 3. * linDis;
    float angle = atan(uv.x, uv.y) / 3.14159265358979 / 2.;
    
    vec3 x = vec3(0);
    if (linDis < 0.15) {
        x = vec3(abs(1. - 2. * fract(-angle + 0.1 * lolDis + 4. * Time)));
    } else {
        vec2 rt = vec2(256. + Time + lolDis + 0.5 * sin(0.4 * lolDis + Time * 2. * 3.14159265358979), 256. + mod(angle * 32.0 + 0.3 * sin((0.2 * lolDis+Time * 2.0) * 3.14159265358979 * 2.),32.));
        if (distance(fract(rt), vec2(0.5)) < 0.5) {
            x = roll(uvec2(rt), time);
        }
    }

    // Output to screen
    gl_FragColor = vec4(x, 1);
}